;               System printer configuration file
;
;	    	Use on Windows to print to system printer
;

;
;   You may produce non-halftoned monochrome output on a color
;   device by setting "num_pens=1".
;
;   When thin vector elements with highly saturated colors are half-toned,
;   they can be extraordinarily difficult to see.  You may wish to
;   assign such element colors to a specific pen.  That pen can in turn
;   be assigned an RGB value of your choice.
;
;   For example, to change element color 5 from a hard to see, highly
;   saturated white to an easier to see gray you could use the following
;   line:
;	    	pen(6)=(5)/rgb=(230, 230, 230)    ; gray
;
num_pens   = 255                            ; required record
model      = sysprinter

stroke_tolerance=10                         ; unitless num 0 < tol < 10

rotate=none
autocenter
;
;  If you are using Windows 95/3.x you will want to change 'hardware' to 
;  'nohardware' in the linestyle definitions below. Otherwise it will result
;  in the inability to plot lines that have both weight and style.  This is
;  due to a limitation in the Graphics Device Interface of Windows 95/3.x.
;  Note that making this change can result in less-compact printer output
;  from MicroStation.
;
style(1)=(12, 36)/hardware               ;style = dot
style(2)=(21, 12)/hardware               ;style = med dash
style(3)=(50, 17)/hardware               ;style = long dash
style(4)=(33, 12, 8, 12)/hardware        ;style = dot-dash
style(5)=(17, 17)/hardware               ;style = short dash
style(6)=(25, 8, 8, 8, 8, 8)/hardware    ;style = dash-dot-dot
style(7)=(33, 8, 17, 8)/hardware         ;style = long dash - short dash

;
; linecap, linejoin and miter_limit
; Note: these settings do not have an effect in Win95/3.x 
;       due to a limitation in the Graphics Device Interface
;
linecap	    = 1			; 1=butt, 2=square, 4=round
linejoin    = 5			; 2=miter/bevel, 4=round, 5=beveled
miter_limit = 1.415     ; Larger values allow longer spikes w/linejoin=2

;
;  You may uncomment this line and adjust the values to customize the
;  logical to physical line weight mapping used by MicroStation printing.
;weight_strokes=(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32)

;
;  The following settings allow the user to control how line-weights in 
;  MicroStation translate into the actual pen-widths used to drawn lines.
;  The pen-width equals offset + (multiplier * line-weight).
;  The offset controls the minimum pen-width used.
;  The multiplier controls the difference between adjacent line-weights.
;  eg. If offset=4 and multiplier=2, a line-weight 1 will yield a pen-width of 6.
;                                    a line-weight 2 will yield a pen-width of 8.
;  eg. If offset=0 and multiplier=1, there is a one-to-one correspondence between
;  line-weight and resulting pen-width. i.e. line-weight 1 yields pen-width 1.
weight_offset=0
weight_multiplier=1

; Remove this if no border is desired
; available qualifiers 
;       /pen=n			    specifies pen to use to draw border
;       /time			    adds time and date to border
;       /filename		    adds name of design file to border
;       /text_height=n      units are cm
;       /width=n		    units are cm
border/pen=1/time/filename/text_height=0.35

; Remove this if no fence outline is desired
fence_outline/pen=1

; specifies Resolution on Mac and Units on Mac and OS/2
resolution(IN)=(0.0,0.0)

; Substitute the name of a pentable file to be loaded when this driver is selected
;pentable=\dir\file.tbl

; Uncomment this line to designate a specific system printer, form, and orientation
; Note that the 3 options can be used alone or in combination
;sysprinter /name=printer-name /form=letter /orientation=portrait

; This keyword controls the size (diameter) of points. Units are cm. 
; A value of 0, disables point drawing.
; Note that with some system printer drivers, setting this value 
; too small, may result in no point being drawn.
point_size = 0.03
largest_polygon=4096

